<?php

///////////////////////////////////////////////////////////////////////////////
///////                           Présentation                          ///////
///////////////////////////////////////////////////////////////////////////////
/*
*******************************************************************
*** La configuration doit être effectuée dans un script externe ***
*** qui portera le nom de la page demandée systématiquement.    ***
***      Lisez photos-exemple.php pour plus d'informations      ***
*******************************************************************

Ce script est un script PHP de galerie photos. Oui, encore un, mais celui qui
répond précisément à mes besoins :

Pour l'utilisateur de la galerie :
- navigation intuitive entre les répertoires et entre les photos
- possibilité d'obtenir les photos en taille originale
- gestion des photos et des films
- respect des standards du web

Pour l'administrateur de la galerie :
- possibilité de mettre les photos originales n'importe où dans l'arborescence
du serveur, en particulier ailleurs que dans la racine du serveur web : les
photos peuvent ne pas être disponibles directement (c'est-à-dire sans passer
par le script) par http
- possibilité d'avoir plusieurs galeries indépendantes sur le même serveur
- renommage facile des galeries, et sans toucher au contenu des scripts PHP
- simplicité de configuration, via un unique fichier texte à éditer
- configuration complète, y compris toutes les couleurs et toutes les tailles
- flexibilité : tout répertoire et tout fichier déposé dans le répertoire
choisi apparaît instantanément
- administration simple et sécurisée à distance : vérification des données de
configuration, gestion du cache (génération des fichiers manquants, nettoyage
des fichiers obsolètes, suppression totale du contenu)
- possibilité d'afficher un lien de téléchargement direct (en ftp par exemple)

Niveau technique :
- sécurité importante (en particulier, aucun accès non prévu n'est autorisé)
- redimensionnement des images avant transfert : gain de bande passante et donc
vitesse accrue
- prérequis minimalistes : fonctionne (normalement, non testé) avec tout OS,
seul PHP5 et la librairie GD de retouche d'images (sous Linux, le paquet
"php5-gd") sont requis ; aucune base de données n'est utilisée
- gestion d'un cache pour toutes les photos redimensionnées et icônes, qui peut
se trouver n'importe où sur le serveur (gain possible de rapidité)

--------
Le cache
--------

Afin d'augmenter la rapidité d'exécution en visionnage, les images
« miniaturisées » (sont concernées les photos, mais aussi les films et les
répertoires, qui sont symbolisés par des icônes) sont enregistrées dans un
cache. Cela prend une faible place (moins de 50ko par image, soit en général à
peine 10% des originaux). Le cache est constitué d'un seul répertoire, qui peut
lui aussi être ou non accessible directement (sans passer par ce script) par
http.

Le cache peut être généré à la volée (toute image non cachée est fabriquée puis
enregistrée dans le cache). Il est aussi possible de le compléter via la page
d'administration. De plus, la page d'administration permet aussi de l'effacer
complètement ou de le nettoyer (supprimer tous les fichiers correspondants à
des photos ou des films obsolètes ou déplacés). Cependant, ces manipulations
peuvent prendre beaucoup de temps et de ressources au serveur.

------------------------
La page d'administration
------------------------

Aucun lien n'est disponible depuis l'affichage "classique". Pour la voir, il
faut demander de charger la page <http://serveur/votre-galerie.php?admin>.
L'authentification est gérée par mot de passe, par PHP. La première page
vérifie les champs de configuration du script initial. Ensuite, on peut
intéractivement compléter, nettoyer et supprimer le contenu du cache.

----------------------
Respects des standards
----------------------

La partie HTML a été écrite dans la recherche du respect maximum des standards
du web, à savoir ceux du W3C. Le site ainsi obtenu est garanti valide
HTML4.01-strict. La mise en forme effectuée par CSS est garantie valide CSS2.1.
Enfin, quelques effets non indispensables en JavaScript ont été rajoutés. Ils
ne nuisent pas à l'accessibilité et la navigation est toujours possible lorsque
le JavaScript est désactivé.
L'interface d'administration, par commodité, utilise de façon assez importante
la technologie appelée AJAX. Il semblerait qu'elle ne fonctionne pas
correctement avec Internet Explorer (au moins en version 6), qui n'implémente
pas correctement les spécifications JavaScript. Vous pouvez utiliser, au moins
pour cette interface, Mozilla Firefox, qui est de bien meilleure qualité.

---------------------
Spécificités requises
---------------------

- Pour la création des images redimensionnées et des icônes, la librairie GD
est utilisée. Si elle n'est pas installée sur le système, le script ne pourra
jamais fonctionner. Sous Linux, il s'agit normalement du paquet php5-gd.
- Le système d'exploitation n'est a priori pas important. Ce script a été testé
sous Linux, mais doit fonctionner sous Windows (et MacOS très certainement).
- Sous Linux au moins, l'utilisateur système lançant le serveur web (par
exemple, pour le serveur web Apache il s'agit en général de l'utilisateur
'www-data') doit avoir accès en lecture au répertoire racine de la galerie et
en écriture au répertoire du cache.
- Lorsque la galerie est de taille importante (au moins 20000 fichiers), la
quantité de mémoire allouée par défaut à un script PHP ne suffit plus au
fonctionnement de l'interface d'administration. Elle est, si possible, modifiée
automatiquement. Si cela ne fonctionne pas, un message d'erreur expliquant le
problème et les possibles solutions sera affiché.

----------
Historique
----------

Une ébauche de galerie photos a été réalisée par Cyril Ravat (alias Will) en
2004. Puis en avril 2006 la toute première version de ce script (version 0.1)
vit le jour, avec un fonctionnement tout neuf, sans aucun rapport avec celui de
la précédente galerie. Il s'agissait toujours d'un fichier PHP unique. De
profondes modifications ont été apportées en juillet 2006 pour séparer le
script originel en plusieurs scripts, plus intelligibles. La page
d'administration a aussi commencé à être ajoutée en juillet. Fin juillet, la
version 0.2 était disponible, avec un certain nombre de bogues. Une deuxième
« vague » de développement a été réalisée en octobre 2006, aboutissant à la
version 0.3, possédant une administration du cache viable.
0.3 : Ajout de l'interface administrative en AJAX.
0.3.1 : Réécriture des explications
0.3.2 : Paramétrage des dimensions
0.3.3 : Paramétrage des couleurs
0.3.4 : Petites corrections de bugs et visualisation d'icônes exemples dans
l'interface administrative
0.3.5 : Correction bug administration du cache
0.3.6 : Corrections bugs administration (liste) du cache (problèmes de mémoire)
et génération d'icônes de répertoires et de films
0.3.7 : En utf-8 (ah, enfin...)
0.3.8 : Balises PHP longues pour compatibilité
0.3.9 : Correction bug redimensionnement de l'image centrale / adresse web

----------
Todo-liste
----------

----------------En priorité---------------
- Mode d'emploi de la galerie (les différents liens), soit affiché
obligatoirement après le message d'accueil, soit disponible partout avec un
petit lien discret ouvrant une fenêtre ou plutôt un div (JS), soit idem en bas.
- Internationalisation ? Version anglaise de photos-exemple.php et de
photos-explications.php. Traduction de chaines.
- Information de la version utilisée et téléchargement des nouvelles versions
disponibles depuis l'interface administrative (Juste lien vers un zip ? ). Il
faut stocker le numéro de version dans l'interface d'administration, subversion
peut nous aider.
------Idées depuis Albulle [http://jebulle.net/?rubrique=albulle]--------
- Mode diaporama
- Téléchargement d'images en zip, par répertoire serait le mieux (problème de mémoire ? )
- En visualisation d'images, voir les données correspondantes
- Mise en valeur des images hoverisées : c'est en css, aucune bordure n'est faite en 
- Pages précédentes/suivante : + numéros de la totalité

------------------------------------------
------------------À voir plus tard-----------------
- Aide à la configuration depuis l'interface administrative. Pas question de
modifier le fichier de configuration directement (vraient pas souhaitable
niveau sécurité -- si en fait, mais avec une copie de sécurité), mais par exemple
modifier les couleurs en AJAX et le reste. Faire une interface qui ressemble à qqch.
-> gestion de l'erreur $scripts incorrect.
-> modification en direct des couleurs des icones -> suppression et régénération
- Simplification du chargement. Réfléchir à comment on peut ne charger que les
données utiles, et non l'ensemble des variables. 

-------
Licence
-------

Ce logiciel est régi par la licence CeCILL soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions de la
licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA sur le site
"http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie, de
modification et de redistribution accordés par cette licence, il n'est offert
aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons, seule une
responsabilité restreinte pèse sur l'auteur du programme, le titulaire des
droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques associés
au chargement, à l'utilisation, à la modification et/ou au développement et à
la reproduction du logiciel par l'utilisateur étant donné sa spécificité de
logiciel libre, qui peut le rendre complexe à manipuler et qui le réserve donc
à des développeurs et des professionnels avertis possédant des connaissances
informatiques approfondies.  Les utilisateurs sont donc invités à charger et
tester l'adéquation du logiciel à leurs besoins dans des conditions permettant
d'assurer la sécurité de leurs systèmes et ou de leurs données et, plus
généralement, à l'utiliser et l'exploiter dans les mêmes conditions de
sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez pris
connaissance de la licence CeCILL, et que vous en avez accepté les termes.

-------
Contact
-------

Je vous invite, si vous détectez des fautes ou coquilles hénaurmes, autant dans
les commentaires que dans le reste, ou encore si vous voyez des problèmes de
sécurité, à me contacter par mail (ravat-à-free-point-fr). Je me tiens aussi à
votre disposition pour toute remarque constructive (bug, demande de
fonctionnalité...) ou autre (insulte, accusation de plagiat...).
*/
?>