<?php
// Ce fichier est un exemple de celui qui doit être appelé par le serveur web
// pour afficher la galerie.
// Pour installer votre galerie, vous devez donc :
// - copier ce fichier dans votre arborescence web, où vous le souhaitez et
// avec le nom que vous souhaitez (laissez l'extension php ; votre galerie web
// sera accessible en demandant ce fichier et uniquement ce fichier).
// - configurer les différentes variables définies ci-dessous pour s'accorder
// avec votre configuration.
// - supprimer la ligne suivante contenant "exit;" pour mettre en
// fonctionnement la galerie.
exit;

///////////////////////////////////////////////////////////////////////////////
//////                      Configuration du script                      //////
///////////////////////////////////////////////////////////////////////////////
// Toutes les explications sont fournies dans le fichier photos-explications.php.

///////////////////////////////////////////////////////////////////////////////
//////                      Configuration générale                       //////
///////////////////////////////////////////////////////////////////////////////

// Titre de la galerie
$titre = "Album-photos pour l'exemple";

// Texte affiché sur la page d'accueil
// Texte à écrire en html, qui sera affiché dans une balise <div>. Attention,
// merci de produire du html4.0Strict sans mise en page par table.
$accueil = "
    <p>Ce site héberge un exemple de galerie photos.</p>
    <p>Vous pouvez agrandir la taille de votre fenêtre pour mieux voir les images (par exemple, en passant en plein écran -- sur la plupart des navigateurs, F11 fait cela).</p>
";

// Adresse (facultative), disponible par le client, contenant les originaux des
// photos de la galerie.
// Cela peut être un lien ftp ou sftp par exemple, mentionnant ou non le port.
// Pour chaque photo/film, l'adresse sera complétée par
// "chemin_depuis_la_racine/fichier.extension". Si aucune valeur n'est donnée
// (chaîne vide), alors aucun lien n'apparaîtra sur les pages de photos.
// Par exemple : "http://photos.domaine.fr/photos/" 
$originaux = "";

///////////////////////////////////////////////////////////////////////////////
//////////                        Répertoires                        //////////
///////////////////////////////////////////////////////////////////////////////

// Chemin absolu du répertoire racine sur le serveur, contenant les photos et
// les films à afficher.
// Il ne se situe pas obligatoirement dans l'espace du serveur web (c'est même
// plutôt recommandé de le mettre autre part).
// Par exemple : "/var/www/photos/", "/Documents/photos/", "F:/photos/"...
$rep_racine = "/photos/";

// Chemin absolu du cache 
// Le cache contient les petites miniatures. Il peut tout à fait se trouver en
// dehors de l'espace du serveur web (et c'est même plutôt conseillé, niveau
// sécurité : aucun accès web au cache). Il peut aussi être sur un autre disque
// physique que les photos et films de la galerie (c'est même assez conseillé
// niveau performance : la mise en cache sera plus rapide). Il faut néanmoins
// et obligatoirement que l'utilisateur exécutant le script PHP (sous Linux il
// s'agit très souvent de "www-data") ait le droit d'écriture. Il doit se
// terminer par un slash.
// Par exemple : "/photos-cache/"
$cache = "/photos-cache/";

// Répertoire contenant les scripts 
// Chemin relatif à partir de l'endroit où est positionné ce script pour
// trouver le reste des scripts de la galerie. Il doit se finir par un slash.
// Il peut être n'importe où sur le serveur (niveau sécurité, il est protégé
// des lectures non autorisées par un index.html vide et un .htaccess très
// restrictif), sauf si le "Safe mode" est activé, auquel cas la configuration
// pourra être plus compliquée. Le "Safe mode" est documenté à l'adresse
// <http://fr.php.net/manual/fr/features.safe-mode.php>.
// Par exemple, "photos/", "../photos", "/documents/galerie-photos".
$scripts = "photos/";

// Police d'affichage dans les images (fichier ".ttf", chemin absolu)
// On utilise la fonction PHP "imagettftext". S'il y a des problèmes
// d'affichage, la solution est certainement dans l'aide de cette fonction :
// <http://fr.php.net/manual/fr/function.imagettftext.php>.
// "/usr/share/fonts/truetype/freefont/FreeSansBold.ttf" semble convenir, et
// appartient au paquet ttf-freefont (au moins sous Ubuntu et Debian). Sous
// Windows, le répertoire contenant les polices est C:\WINDOWS\Fonts.
$police = "/usr/share/fonts/truetype/freefont/FreeSansBold.ttf";

///////////////////////////////////////////////////////////////////////////////
//////                     Couleurs et mise en forme                     //////
///////////////////////////////////////////////////////////////////////////////

// Couleurs HTML
// Ces couleurs doivent être exprimées de façon valide pour du HTML,
// c'est-à-dire, au choix :
//   #RVB (R rouge entre 0 et F -> 16 niveaux, V vert, B bleu)
//   #RRVVBB (RR rouge entre 00 et FF -> 255 niveaux, VV vert, BB bleu)
//   rgb(xx%,xx%,xx%) (xx entre 0 et 100 pour le rouge, le vert, le bleu)
//   rgb(xxx,xxx,xxx) (xxx entre 0 et 255 pour le rouge, le vert, le bleu)
// Le blanc est avec les trois couleurs à 100%/255/FF, le noir avec 3 zéro.

// Fond de la page
// Par exemple, "#FFF" (blanc)
$couleur_html_fond = "#FFF";
// Textes (titre, nom des répertoires, texte d'accueil)
// Par exemple, "#000" (noir)
$couleur_html_texte = "#000";
// Lien de retour (en haut, lors de la visualisation des images)
// Par exemple, "#335" (bleu foncé)
$couleur_retour = "#335";
// Fond du lien de retour
// Par exemple, "#AA8" (gris-vert foncé)
$couleur_retour_fond = "#AA8";
// Liens vers les pages précédentes/suivantes (si plusieurs pages)
// Par exemple, "#999" (gris clair)
$couleur_pages = "#999";
// Texte de la "publicité" (petit texte en bas)
// Par exemple, "#999" (gris clair)
$couleur_pub = "#999";
// Fond du bandeau de "publicité"
// Par exemple, "#FFF" (blanc)
$couleur_pub_fond = "#FFF";
// Lien direct (vers les originaux, en bas lors de la visualisation des images)
// Par exemple, "#559" (bleu foncé)
$couleur_lien = "#559";
// Liens, quand la souris passe dessus (pour la "publicité" et le "lien direct)
// Par exemple, "#955" (rouge foncé)
$couleur_hover = "#955";

// Couleurs des miniatures et d'icônes
// Ces couleurs doivent être exprimées par trois nombres représentants les
// valeurs du rouge, du vert et du bleu, nombres compris entre 0 et 255.
// N'oubliez pas de vider le cache (ou au moins de supprimer les miniatures ou
// icônes concernées) si vous souhaitez que ces valeurs soient considérées.

// Fond des miniatures de photos et des icônes de films
// Par exemple, "240,240,240" (gris clair)
$couleur_photos_fond = "240,240,240";
// Textes des miniatures de photos (taille n°2) et des icônes de films
// Par exemple, "0,0,0" (noir)
$couleur_photos_texte = "0,0,0";
// Triangle symbolisant la lecture dans les icônes des films
// Par exemple, "0,0,0" (noir)
$couleur_films_triangle = "0,0,0";
// Disque entourant le triangle dans les icônes des films
// Par exemple, "255,255,255" (blanc)
$couleur_films_disque = "255,255,255";
// Fond des icônes des répertoires
// Par exemple, "200,200,250" (gris-bleu foncé)
$couleur_rep_fond = "200,200,250";
// Texte sur les icônes des répertoires
// Par exemple, "0,0,0" (noir)
$couleur_rep_texte = "0,0,0";

///////////////////////////////////////////////////////////////////////////////
//////                Partie technique de la configuration               //////
///////////////////////////////////////////////////////////////////////////////

// Nombre maximal de vignettes par page
// Ce nombre comprend, dans le cas de la présence de sous-répertoires, les 
// vignettes des sous-répertoires ainsi que des images. 35 semble être une
// bonne valeur.
$nbmax = 35;

// Utilisateurs et mots de passe de la partie administrative
// Il s'agit d'un tableau de chaînes, dont les clés sont les utilisateurs et
// les valeurs sont les mots de passe. Les mots de passe doivent être des
// chaînes chiffrées par la fonction md5(), donc de 32 caractères. Pour obtenir
// la valeur correpondante à un mot de passe, il est possible de taper ici
// temporairement "echo md5('le-mot-de-passe');", puis de lancer le script dans
// son navigateur, copier la valeur, la coller ici et surtout enlever le
// "echo md5('le-mot-de-passe');".
// Par exemple, cela donnera, pour trois utilisateurs :
// "$utilisateurs = array('utilisateur1' => 'mot-de-passe-1-md5isé',
//                        'utilisateur2' => 'mot-de-passe-2-md5isé',
//                        'utilisateur3' => 'mot-de-passe-3-md5isé');"
// Décommenter et remplacer le mot de passe pour avoir sa valeur
//echo md5('mot-de-passe');
$utilisateurs = array(
);

// Dimensions des miniatures
// $dimensions est un tableau contenant les deux tailles en pixels (les
// miniatures sont des carrés ; la première dimensions est la plus grande). Une
// bordure de 10 pixels sera insérée à l'intérieur de ces dimensions.
// Par exemple, "array(600,120)" pour des tailles respectives de 600 et 120 px.
$dimensions = array(600,120);

///////////////////////////////////////////////////////////////////////////////
//////                 Fin de la configuration du script                 //////
///////////////////////////////////////////////////////////////////////////////
// Pour que l'appel aux autres scripts fonctionne.
define("OK",1);

// Appel au script
include("{$scripts}photos-script.php");
?>