<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();
?>

<script type="text/javascript" language="javascript">
// Fonction implémentant simplement une connexion via AJAX
// Script modifié à partir de http://developer.mozilla.org/fr/docs/AJAX:Premiers_pas
function makeRequest(url,ma_fonction) {
  var http_request = false;
  // Mozilla, Safari,...
  if (window.XMLHttpRequest)  http_request = new XMLHttpRequest();
  else if (window.ActiveXObject) { // IE
    try  { http_request = new ActiveXObject("Msxml2.XMLHTTP"); }
    catch (e) {
      try  { http_request = new ActiveXObject("Microsoft.XMLHTTP"); }
      catch (e) {}
    }
  }
  if (!http_request) {
    alert('Abandon :( Impossible de créer une instance XMLHTTP');
    return false;
  }
  http_request.onreadystatechange = function() { 
    if (http_request.readyState == 4)  {
      if (http_request.status == 200)  ma_fonction(http_request);
      else  alert('Un problème est survenu avec la requête.');
    }
  }
  http_request.open('GET', url, true);
  http_request.send(null);
}

function cache() {
  try  {
    // Suppression de l'affichage de la configuration si besoin
    document.body.removeChild(document.getElementById("configuration"));
    // Suppression du lanceur de cette action si besoin
    document.body.removeChild(document.getElementById("cache"));
  }
  catch (e)  {}

  // Affichage d'un message d'attente
  try  {
    var attente = document.getElementById("attente");
    attente.innerHTML = "Veuillez patienter pendant le chargement des données du cache...";
  }
  catch (e)  {
    var attente = document.createElement("p");
    attente.setAttribute("id","attente");
    attente.innerHTML = "Veuillez patienter pendant le chargement des données du cache...";
    document.body.appendChild(attente);
  }
  
  // Récupération de la liste des images à générer
  makeRequest('<?php echo $script; ?>?admin&cache&liste',recup);
}

function recup(http_request) {
  // Récupération des données
  eval(http_request.responseText);
  
  // Pluriels 
  if ( nbreps < 2 )  nbreps = "" + nbreps + " répertoire";
  else  nbreps = "" + nbreps + " répertoires";
  if ( nbfichiers < 2 )  nbfichiers = "" + nbfichiers + " fichier";
  else  nbfichiers = "" + nbfichiers + " fichiers";
  if ( nbcache_actuel < 2 )  nbcache_actuel = "" + nbcache_actuel + " fichier.";
  else  nbcache_actuel = "" + nbcache_actuel + " fichiers.";
  if ( nbcache_final < 2 )  nbcache_final = "" + nbcache_final + " fichier";
  else  nbcache_final = "" + nbcache_final + " fichiers";
  try  {
    var nbcache_suppr = ( images_obsoletes[0] == '' ) ? 0 : images_obsoletes.length - !images_obsoletes.length ;
  }
  catch(e)  {}

  // Suppression du message d'attente
  document.body.removeChild(document.getElementById("attente"));
  
  // Affichage
  var affiche = document.createElement("div");
  affiche.setAttribute("id","affiche");
  var prep = document.createElement("p");
  prep.innerHTML = "Le répertoire racine contient au total " + nbreps + " et " + nbfichiers + " affichables dans la galerie (photos ou films), ce qui correspond à " + nbcache_final + " dans le cache.";
  var pcache = document.createElement("p");
  pcache.innerHTML = "Le cache contient actuellement " + nbcache_actuel;
  
  // Actions
  var action = document.createElement("div");
  action.setAttribute("id","action");
  var genere = document.createElement("p");
  switch(nbcache_manque) {
    case 0:
      genere.innerHTML = "Le cache est complet (aucun fichier à générer).";
      break;
    case 1:
      genere.innerHTML = "Il manque un fichier pour que le cache soit complet.<br>Voulez-vous le générer&nbsp;?";
      break;
    default:
      genere.innerHTML = "Il manque " + nbcache_manque + " fichiers pour que le cache soit complet.<br>Voulez-vous les générer&nbsp;?";  
  }
  var nettoie = document.createElement("p");
  switch(nbcache_suppr) {
    case 0:
      // Pas d'affichage si aucun fichier à supprimer
      break;
    case 1:
      nettoie.innerHTML = "Il y a un fichier obsolète dans le cache.<br>Voulez-vous le supprimer&nbsp;?";
      break;
    case -1:
      nettoie.innerHTML = "La liste des fichiers obsolètes dans le cache n'a pas pu être construite par le script PHP. Cela vient probablement d'un manque de mémoire, et du fait que la variable memory_limit n'a pas pu être modifiée par le script PHP. Il faut soit l'y autoriser, soit augmenter la valeur dans le script photos-liste-cache.php, soit augmenter sa valeur dans le fichier de configuration php.ini (déconseillé).";
      nettoie.setAttribute("style"," font-size: 1.3em ; text-align: justify ; text-decoration: none ; cursor: default ; ");
      break;
    default:
      nettoie.innerHTML = "Il y a " + nbcache_suppr + " fichiers obsolètes dans le cache.<br>Voulez-vous les supprimer&nbsp;?";  
  }
  var vide = document.createElement("p");
  vide.innerHTML = "Vider le cache";
  // Liens vers chaque action
  genere.setAttribute("onClick","javascript:generer(images_manquantes)");
  if ( nbcache_suppr > 0 )
    nettoie.setAttribute("onClick","javascript:nettoyer(images_obsoletes)");
  vide.setAttribute("onClick","javascript:vider()");
  
  // Ajout des blocs à afficher
  affiche.appendChild(prep);
  affiche.appendChild(pcache);  
  if ( nbcache_manque )  action.appendChild(genere);
  if ( nbcache_suppr )  action.appendChild(nettoie);
  if ( nbcache_actuel != '0 fichier.' )  action.appendChild(vide);
  document.body.appendChild(affiche);
  document.body.appendChild(action);
}

function generer(images_manquantes)  {
  // Suppression des affichages présents
  document.body.removeChild(document.getElementById("affiche"));
  // Suppression du lanceur de cette action
  document.body.removeChild(document.getElementById("action"));

  // Affichage d'un message d'attente
  var attente = document.createElement("div");
  attente.setAttribute("id","attente");
  var attente_debut = document.createElement("p");
  attente_debut.innerHTML = "Le cache est en cours de génération...";
  var avancement = document.createElement("p");
  avancement.innerHTML = '0 fichier généré, soit 0%';
  avancement.setAttribute("id","avancement");
  var temps = document.createElement("p");
  temps.innerHTML = 'en 0 seconde';
  temps.setAttribute("id","temps");
  var restant = document.createElement("p");
  restant.innerHTML = 'Temps restant indéfini';
  restant.setAttribute("id","restant");
  var temps_restant = document.createElement("p");
  temps_restant.setAttribute("id","temps_restant");
  attente.appendChild(attente_debut);
  attente.appendChild(avancement);
  attente.appendChild(temps);
  attente.appendChild(restant);
  attente.appendChild(temps_restant);
  document.body.appendChild(attente);
  
  // Suppression de toutes les images du cache
  // On est obligés de passer par une fonction appelée récusivement, car sinon toutes les requêtes sont lancées simultanément.
  var n = images_manquantes.length;
  var debut = Date.now();
  ok = 1;
  generer_recursif(images_manquantes,0,n,debut);
  // Sera effectué de suite après le premier appel à generer_recursif
  restant.innerHTML = 'Temps restant approximatif&nbsp;: ';
}

function generer_recursif(images_manquantes,i,n,debut)  {
  if ( i == n )  {
    var attente = document.getElementById("attente");
    attente.removeChild(document.getElementById("restant"));
    attente.removeChild(document.getElementById("temps_restant"));
    var avancement = document.getElementById("avancement");
    avancement.innerHTML = '' + n + ' fichiers générés, soit 100%';
    var temps = document.getElementById("temps");
    temps.innerHTML = 'en ' + afficher_temps(Date.now()-debut);
    // Rechargement des données du cache
    setTimeout(cache,300);
    return;
  }
  if ( ok )  {
    var image = images_manquantes[i];
    if ( image.length > 1 )
      makeRequest('<?php echo $script; ?>?admin&cache&rep=' + image[0] + '&img=' + image[1] + '&t=' + image[2] ,reponse_ok);
    else
      makeRequest('<?php echo $script; ?>?admin&cache&rep=' + image[0] ,reponse_ok);
    var maintenant = Date.now();
    var avancement = document.getElementById("avancement");
    avancement.innerHTML = '' + (++i) + ' fichiers générés, soit ' + Math.round( 100*i/n ) + '%';
    var temps = document.getElementById("temps");
    temps.innerHTML = 'en ' + afficher_temps(maintenant-debut);
    var temps_restant = document.getElementById("temps_restant");
    temps_restant.innerHTML = afficher_temps((maintenant-debut)*(n-i)/i);
    ok = 0;
    generer_recursif(images_manquantes,i,n,debut);
  }
  // Si ok n'est pas encore égal à 1 (et donc, si le script PHP n'a pas encore fini), on attend 200ms et on recommence.
  else  setTimeout(generer_recursif,200,images_manquantes,i,n,debut);
}

function nettoyer(images_obsoletes)  {
  // Suppression des affichages présents
  document.body.removeChild(document.getElementById("affiche"));
  // Suppression du lanceur de cette action
  document.body.removeChild(document.getElementById("action"));

  // Affichage d'un message d'attente
  var attente = document.createElement("div");
  attente.setAttribute("id","attente");
  var attente_debut = document.createElement("p");
  attente_debut.innerHTML = "Le cache est en cours de nettoyage...";
  var avancement = document.createElement("p");
  avancement.innerHTML = '0 fichier supprimé, soit 0%';
  avancement.setAttribute("id","avancement");
  var temps = document.createElement("p");
  temps.innerHTML = 'en 0 seconde';
  temps.setAttribute("id","temps");
  var restant = document.createElement("p");
  restant.innerHTML = 'Temps restant indéfini';
  restant.setAttribute("id","restant");
  var temps_restant = document.createElement("p");
  temps_restant.setAttribute("id","temps_restant");
  attente.appendChild(attente_debut);
  attente.appendChild(avancement);
  attente.appendChild(temps);
  attente.appendChild(restant);
  attente.appendChild(temps_restant);
  document.body.appendChild(attente);
  
  // Suppression de toutes les images du cache
  // On est obligés de passer par une fonction appelée récusivement, car sinon toutes les requêtes sont lancées simultanément.
  var n = images_obsoletes.length;
  var debut = Date.now();
  ok = 1;
  nettoyer_recursif(images_obsoletes,0,n,debut);
  // Sera effectué de suite après le premier appel à generer_recursif
  restant.innerHTML = 'Temps restant approximatif&nbsp;: ';
}

function nettoyer_recursif(images_obsoletes,i,n,debut)  {
  if ( i == n )  {
    var attente = document.getElementById("attente");
    attente.removeChild(document.getElementById("restant"));
    attente.removeChild(document.getElementById("temps_restant"));
    var avancement = document.getElementById("avancement");
    avancement.innerHTML = '' + n + ' fichiers supprimés, soit 100%';
    var temps = document.getElementById("temps");
    temps.innerHTML = 'en ' + afficher_temps(Date.now()-debut);
    // Rechargement des données du cache
    setTimeout(cache,300);
    return;
  }
  if ( ok )  {
    makeRequest('<?php echo $script; ?>?admin&cache&nettoie=' + images_obsoletes[i] ,reponse_ok);
    var maintenant = Date.now();
    var avancement = document.getElementById("avancement");
    avancement.innerHTML = '' + (++i) + ' fichiers supprimés, soit ' + Math.round( 100*i/n ) + '%';
    var temps = document.getElementById("temps");
    temps.innerHTML = 'en ' + afficher_temps(maintenant-debut);
    var temps_restant = document.getElementById("temps_restant");
    temps_restant.innerHTML = afficher_temps((maintenant-debut)*(n-i)/i);
    ok = 0;
    nettoyer_recursif(images_obsoletes,i,n,debut);
  }
  else  setTimeout(nettoyer_recursif,200,images_obsoletes,i,n,debut);
}

function vider()  {
  // Suppression des affichages présents
  document.body.removeChild(document.getElementById("affiche"));
  // Suppression du lanceur de cette action
  document.body.removeChild(document.getElementById("action"));

  // Affichage d'un message d'attente
  var attente = document.createElement("p");
  attente.setAttribute("id","attente");
  attente.innerHTML = "Le cache est en cours de suppression totale...";
  document.body.appendChild(attente);
  
  // Suppression de toutes les images du cache et rechargement des données du cache
  makeRequest('<?php echo $script; ?>?admin&cache&vide',cache);
}

function reponse_ok(http_request)  { ok = 1; }

function afficher_temps(millisecondes)  {
  var secondes = Math.round(millisecondes/1000);
  var jours = Math.floor( secondes/86400 );
  var heures = Math.floor( (secondes%86400)/3600 );
  var minutes = Math.floor( (secondes%3600)/60 );
  secondes = secondes%60;
  var affichage = '';
  if ( jours == 1 )  affichage += "1 jour ";
  else if ( jours > 1 ) affichage += jours + " jours ";
  if ( heures == 1 )  affichage += "1 heure ";
  else if ( heures > 1 ) affichage += heures + " heures ";
  if ( minutes == 1 )  affichage += "1 minute ";
  else if ( minutes > 1 ) affichage += minutes + " minutes ";
   if ( secondes == 1 )  affichage += "1 seconde ";
  else if ( secondes > 1 ) affichage += secondes + " secondes ";
  return ( affichage == '' ) ? "0 seconde" : affichage;
}

// Initialisation des tableaux comme variables globales
var images_manquantes = new Array();
var images_obsoletes = new Array();
// Initialisation de la variable "ok" qui sait si oui ou non le serveur a répondu
var ok = 0;

</script>